/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateRectangle.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Finds the four corners of the rectangle from the two given points,
//	creates four lines using these four corners, creares an object set
//	and adds each line to this set.
//	Returns the object set after applying AutoConstrain on it

HRESULT CreateRectangle(double topLeftX, double topLeftY,
						double bottomRightX, double bottomRightY, ISet **dObjectSet1)
{

	START_METHOD("CreateRectangle")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *vector2D[4] = { NULL, NULL, NULL, NULL };
	IVector *vector3D[4] = { NULL, NULL, NULL, NULL };

	// Create 2D vector ( top-left corner )
	status = (GetCLASS(Vector))->CreateVector(topLeftX, topLeftY, 0, &vector2D[0]);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector ( top-left corner )
	status = activeWorkplane->Get3DVector(vector2D[0], &vector3D[0]);
	CHECK_RETURN_STATUS(status)

	// Create 2D vector ( top-right corner )
	status = (GetCLASS(Vector))->CreateVector(bottomRightX, topLeftY, 0, &vector2D[1]);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector ( top-right corner )
	status = activeWorkplane->Get3DVector(vector2D[1], &vector3D[1]);
	CHECK_RETURN_STATUS(status)

	// Create 2D vector ( bottom-right corner )
	status = (GetCLASS(Vector))->CreateVector(bottomRightX, bottomRightY, 0, &vector2D[2]);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector ( bottom-right corner )
	status = activeWorkplane->Get3DVector(vector2D[2], &vector3D[2]);
	CHECK_RETURN_STATUS(status)

	// Create 2D vector ( bottom-left corner )
	status = (GetCLASS(Vector))->CreateVector(topLeftX, bottomRightY, 0, &vector2D[3]);
	CHECK_RETURN_STATUS(status)

	// Get the 3D vector ( bottom-left corner )
	status = activeWorkplane->Get3DVector(vector2D[3], &vector3D[3]);
	CHECK_RETURN_STATUS(status)

	// Create an object set
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *straight[4] = { NULL, NULL, NULL, NULL };
	ILine *line[4] = { NULL, NULL, NULL, NULL };

	for(int i=0; i<4; i++) {

		// Create basic straight line
		status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(vector3D[i],
												vector3D[(i+1)%4], &straight[i]);
		CHECK_RETURN_STATUS(status)

		// Create aLine object
		status = activeSketch->CreateLine(CAST(ICurve, straight[i]), &line[i]);
		CHECK_RETURN_STATUS(status)

		// Add the line to the object set
		aLineSet1->AddMember(line[i]);
		CHECK_RETURN_STATUS(status)
	}
	*dObjectSet1 = aLineSet1;

	// Apply AutoConstrain on the set of lines created
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateRectangle")
}
